---
title: How to Contribute
summary: This guide explains how to contribute to Tabler, from setting up a development environment to making and testing changes. It covers essential steps like forking the repository, installing dependencies, and submitting a pull request to help improve Tabler's features and functionality.
description: Guide to contributing to Tabler and setting up for development.
---

Contributions are always welcome and highly encouraged! Whether you're new to open source or a seasoned contributor, your input helps make Tabler better for everyone. If you're new to open source, we recommend reading a [how to contribute](https://opensource.guide/how-to-contribute/) guide to learn more about contributing.

## Contribution Requirements

When contributing to Tabler, please adhere to the following guidelines:

1. By submitting a contribution, you grant a non-exclusive license to the Tabler project to use your contribution in any context deemed appropriate.
2. If your contribution includes content from other sources, it must be appropriately licensed under an open source license.
3. Contributions must be submitted via GitHub pull requests.
4. Ensure your code works in all supported browsers (refer to our [browser support documentation](/ui/getting-started/browser-support)).

## Installation

Follow these steps to set up Tabler for development:

1. Fork the repository: [Guide to forking](https://docs.github.com/en/get-started/quickstart/fork-a-repo).

2. Clone the repository to your local machine:

   ```bash
   git clone https://github.com/YOUR_USERNAME/tabler.git
   ```

3. Create a new branch for your changes:

   ```bash
   git checkout -b your-branch-name
	```

## Development

To set up Tabler for development, follow these steps:

<div class="steps steps-vertical">

### Ensure Node.js and pnpm are installed

You’ll need Node.js (v20 or higher) and pnpm to compile Tabler’s files. If you don’t have them installed, download and install them from the official websites:

- [Node.js](https://nodejs.org/)
- [pnpm](https://pnpm.io/) (we use pnpm over other package managers for faster installation).

### Install dependencies

Run the following command to install all required npm packages:

```bash
pnpm install
```

### Start developer mode

Use the following command to enable autocompilation with live reload. This will start up the preview website at `http://localhost:3000/`, and the documentation website at `http://localhost:3010/`:

```bash
pnpm run dev
```

### Make changes

Make your changes in the appropriate folders, such as `./core/`, `./preview/` or `./docs/`. Avoid modifying files in any `dist` folders, as they are auto-generated during the build process and will be overwritten.
</div>

## Compiling for Production

Before submitting a pull request, ensure your changes are properly compiled and tested:

1. Compile the production files

	```bash
	pnpm run build
	```

2. Test all pages to confirm everything works as expected.

## Submitting Your Contribution

Once your changes are ready, create a pull request (PR) on GitHub. Make sure to include a clear and concise description of the changes and their purpose. Thank you for contributing to Tabler!